// NetReceiverDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetReceiver.h"
#include "NetReceiverDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CNetReceiverApp theApp;

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetReceiverDlg dialog

CNetReceiverDlg::CNetReceiverDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNetReceiverDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetReceiverDlg)
	m_nProtocol = -1;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNetReceiverDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetReceiverDlg)
	DDX_Control(pDX, IDC_EDIT_RECORD_PATH, m_editRecordPath);
	DDX_Control(pDX, IDC_STATIC_VIDEO_INFO, m_statVideoInfo);
	DDX_Control(pDX, IDC_STATIC_AUDIO_INFO, m_statAudioInfo);
	DDX_Control(pDX, IDC_EDIT_URL, m_editURL);
	DDX_Control(pDX, IDC_STATIC_DISPLAY_WINDOW, m_statDisplayWindow);
	DDX_Radio(pDX, IDC_RADIO_UDP, m_nProtocol);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNetReceiverDlg, CDialog)
	//{{AFX_MSG_MAP(CNetReceiverDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_START_RECORD, OnButtonStartRecord)
	ON_BN_CLICKED(IDC_BUTTON_STOP_RECORD, OnButtonStopRecord)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetReceiverDlg message handlers

QRETURN on_video_broadcast_client_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	CNetReceiverDlg * pNetReceiverDlg = (CNetReceiverDlg *)(pUserData);

	pNetReceiverDlg->m_nNetworkVideoStreamSize += nStreamBufferLen;

	pNetReceiverDlg->m_nNetworkVideoFrames++;

	return QCAP_RT_OK;
}

QRETURN on_audio_broadcast_client_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, PVOID pUserData )
{
	CNetReceiverDlg * pNetReceiverDlg = (CNetReceiverDlg *)(pUserData);

	pNetReceiverDlg->m_nNetworkAudioStreamSize += nStreamBufferLen;

	pNetReceiverDlg->m_nNetworkAudioFrames++;

	return QCAP_RT_OK;
}

QRETURN on_video_decoder_broadcast_client_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CNetReceiverDlg * pNetReceiverDlg = (CNetReceiverDlg *)(pUserData);

//	SC_DEBUG( "on_video_decoder_broadcast_client_callback( %f, %d )", dSampleTime, nFrameBufferLen );

	pNetReceiverDlg->m_nNetworkVideoDecoderFrames++;

	return QCAP_RT_OK;
}

QRETURN on_audio_decoder_broadcast_client_callback( PVOID pClient, UINT iSessionNum, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CNetReceiverDlg * pNetReceiverDlg = (CNetReceiverDlg *)(pUserData);

//	SC_DEBUG( "on_audio_decoder_broadcast_client_callback( %f, %d )", dSampleTime, nFrameBufferLen );

	pNetReceiverDlg->m_nNetworkAudioDecoderFrames++;

	return QCAP_RT_OK;
}

BOOL CNetReceiverDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	m_pNetworkReceiver = NULL;

	m_nNetworkVideoStreamSize = 0;

	m_nNetworkAudioStreamSize = 0;

	m_nNetworkVideoFrames = 0;

	m_nNetworkAudioFrames = 0;

	m_nNetworkVideoDecoderFrames = 0;

	m_nNetworkAudioDecoderFrames = 0;

	// INITIALIZE USER INTERFACE
	//
	m_editURL.SetWindowText( theApp.GetProfileString( "DEFAULT", "URL", "rtsp://10.10.80.149:8000/es" ) );	

	m_nProtocol = theApp.GetProfileInt( "DEFAULT", "PROTOCOL", 0 );

	UpdateData( FALSE );

	m_strRecordPathName = GetWorkingPath( "CH01.MP4" );

	m_editRecordPath.SetWindowText( m_strRecordPathName );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_START_RECORD )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP_RECORD )->EnableWindow( FALSE );

	SetTimer( 0x00000000, 1000, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNetReceiverDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	// DISCONNECTION
	//
	OnButtonStop();

	// UNINITIALIZE USER INTERFACE
	//
	KillTimer( 0x00000000 );

	UpdateData( TRUE );

	CString strURL;

	m_editURL.GetWindowText( strURL );

	theApp.WriteProfileString( "DEFAULT", "URL", (LPCTSTR)(strURL) );

	theApp.WriteProfileInt( "DEFAULT", "PROTOCOL", m_nProtocol );
	
	// UNINITIALIZE COM LIBRARY
	//
	CoUninitialize();
}

void CNetReceiverDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNetReceiverDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNetReceiverDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CNetReceiverDlg::OnOK() 
{
	// TODO: Add extra validation here

//	CDialog::OnOK();
}

void CNetReceiverDlg::OnCancel() 
{
	// TODO: Add extra cleanup here

	CDialog::OnCancel();
}

void CNetReceiverDlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here
	
	OnButtonStop();

	m_pNetworkReceiver = NULL;

	m_nNetworkVideoStreamSize = 0;

	m_nNetworkAudioStreamSize = 0;

	m_nNetworkVideoFrames = 0;

	m_nNetworkAudioFrames = 0;

	m_nNetworkVideoDecoderFrames = 0;

	m_nNetworkAudioDecoderFrames = 0;

	UpdateData( TRUE );

	CString strURL;

	m_editURL.GetWindowText( strURL );

	CHAR psz[ MAX_PATH ];

	sprintf( psz, "%s", strURL );

	QCAP_CREATE_BROADCAST_CLIENT( 0, psz, &m_pNetworkReceiver, QCAP_DECODER_TYPE_SOFTWARE, m_statDisplayWindow.m_hWnd, TRUE );

	QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME( m_pNetworkReceiver, 0, 100);

	QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_video_broadcast_client_callback, this );

	QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_audio_broadcast_client_callback, this );

	QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_video_decoder_broadcast_client_callback, this );

	QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK( m_pNetworkReceiver, on_audio_decoder_broadcast_client_callback, this );

	if( m_nProtocol == 0 ) { QCAP_START_BROADCAST_CLIENT( m_pNetworkReceiver, QCAP_BROADCAST_PROTOCOL_UDP ); }

	if( m_nProtocol == 1 ) { QCAP_START_BROADCAST_CLIENT( m_pNetworkReceiver, QCAP_BROADCAST_PROTOCOL_TCP ); }	

	if( m_nProtocol == 2 ) { QCAP_START_BROADCAST_CLIENT( m_pNetworkReceiver, QCAP_BROADCAST_PROTOCOL_HTTP ); }

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( TRUE );
}

void CNetReceiverDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here

	if( m_pNetworkReceiver ) {

		QCAP_STOP_BROADCAST_CLIENT( m_pNetworkReceiver );

		QCAP_DESTROY_BROADCAST_CLIENT( m_pNetworkReceiver );

		m_pNetworkReceiver = NULL;
	}
	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );
}

void CNetReceiverDlg::OnButtonStartRecord() 
{
	// TODO: Add your control notification handler code here
	
	OnButtonStopRecord();

	if( m_pNetworkReceiver ) {

		QCAP_START_BROADCAST_CLIENT_RECORD( m_pNetworkReceiver, 0, m_strRecordPathName.GetBuffer( 256 ) );

		m_strRecordPathName.ReleaseBuffer();
	}

	GetDlgItem( IDC_BUTTON_START_RECORD )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP_RECORD )->EnableWindow( TRUE );
}

void CNetReceiverDlg::OnButtonStopRecord() 
{
	// TODO: Add your control notification handler code here

	if( m_pNetworkReceiver ) {

		QCAP_STOP_BROADCAST_CLIENT_RECORD( m_pNetworkReceiver, 0 );
	}

	GetDlgItem( IDC_BUTTON_START_RECORD )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP_RECORD )->EnableWindow( FALSE );
}

void CNetReceiverDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	CHAR psz[ MAX_PATH ];

	sprintf( psz, "VIDEO: %d KB (%d / %d)", (ULONG)(m_nNetworkVideoStreamSize / 1024), m_nNetworkVideoFrames, m_nNetworkVideoDecoderFrames );

	m_statVideoInfo.SetWindowText( psz );

	sprintf( psz, "AUDIO: %d KB (%d / %d)", (ULONG)(m_nNetworkAudioStreamSize / 1024), m_nNetworkAudioFrames, m_nNetworkAudioDecoderFrames );

	m_statAudioInfo.SetWindowText( psz );

	CDialog::OnTimer(nIDEvent);
}


CString CNetReceiverDlg::GetWorkingPath(CString strWorkFile)
{
	TCHAR szCurPath[MAX_PATH] = {0};

	GetModuleFileName(NULL, szCurPath, MAX_PATH);

	CString strCurPath = szCurPath;

	strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

	strCurPath += strWorkFile;

	return strCurPath;
}
